import React from "react";
import { Pressable } from "react-native";
import TimesIcon from "../../../assets/svgs/drawer/times.svg";
import dpr from "../../../screens/Utilities/CustomStyleAttribute/dpr";
import PhotoGalleryStyle from "./CustomPhotoGallery.style";
import CustomSVG from "../CustomSVG/CustomSVG";

const RenderHeader = ({ setIsOpen, updateIndex, setCurrentSlideIndex }) => {
    const photoGalleryStyle = PhotoGalleryStyle();
    return (
        <Pressable
            onPress={() => {
                setIsOpen(false);
                setCurrentSlideIndex && setCurrentSlideIndex(updateIndex);
            }}
            style={photoGalleryStyle.closeIcon}
        >
            <CustomSVG svgIcon={TimesIcon} height={dpr(15)} width={dpr(15)} fill={"#FFFFFF"} />
        </Pressable>
    );
};

export default RenderHeader;
